<?php
$page_title = "Categories";
$page_description = "Browse our product categories including smartphones, household appliances, kitchen appliances, and electronics at SavingVest Mart.";

require_once 'config/database.php';
include 'includes/header.php';

$conn = getDBConnection();
$categories = [];
$result = $conn->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY name ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
}
$conn->close();
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Product Categories</h1>
        <p class="text-gray-600 mt-2">Explore our wide range of product categories</p>
    </div>
</section>

<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php foreach ($categories as $category): ?>
            <a href="products.php?category=<?php echo urlencode($category['slug']); ?>" 
               class="group bg-white rounded-2xl shadow-sm hover:shadow-lg transition-all duration-300 overflow-hidden">
                <div class="aspect-w-16 aspect-h-12 bg-gray-100">
                    <img src="<?php echo htmlspecialchars($category['image_url']); ?>" 
                         alt="<?php echo htmlspecialchars($category['name']); ?>"
                         class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-2 group-hover:text-primary-600 transition-colors">
                        <?php echo htmlspecialchars($category['name']); ?>
                    </h3>
                    <p class="text-gray-600 mb-4"><?php echo htmlspecialchars($category['description']); ?></p>
                    <span class="text-primary-600 font-medium group-hover:underline">Browse Products →</span>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
