<?php
@session_start();
require_once 'config/database.php';

// Get cart count for logged in users
$cart_count = 0;
if (isset($_SESSION['user_id'])) {
    $conn = getDBConnection();
    $user_id = $_SESSION['user_id'];
    $result = $conn->query("SELECT SUM(quantity) as total FROM cart_items WHERE user_id = $user_id");
    if ($result && $row = $result->fetch_assoc()) {
        $cart_count = $row['total'] ?? 0;
    }
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' . SITE_NAME : SITE_NAME . ' - Premium Electronics & Home Appliances'; ?></title>
    <meta name="description" content="<?php echo isset($page_description) ? $page_description : 'Shop premium smartphones, household appliances, and electronics at SavingVest Mart. Quality products, competitive prices, fast shipping.'; ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            500: '#10b981',
                            600: '#059669',
                            700: '#047857'
                        },
                        accent: {
                            500: '#3b82f6',
                            600: '#2563eb'
                        }
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-gray-50">
    <!-- Navigation Header -->
    <header class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="index.php" class="flex items-center space-x-3">
                        <!-- Replaced simple "S" logo with professional SVG logo -->
                        <img src="assets/images/logo.png" alt="SavingVest Mart" class="h-10 w-auto">
                    </a>
                </div>

                <!-- Search Bar -->
                <div class="flex-1 max-w-lg mx-8">
                    <form action="search.php" method="GET" class="relative">
                        <input type="text" name="q" placeholder="Search products..." 
                               class="w-full pl-4 pr-12 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
                        <button type="submit" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-primary-500">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </button>
                    </form>
                </div>

                <!-- Navigation Links -->
                <nav class="hidden md:flex items-center space-x-8">
                    <a href="products.php" class="text-gray-700 hover:text-primary-600 font-medium">Products</a>
                    <a href="categories.php" class="text-gray-700 hover:text-primary-600 font-medium">Categories</a>
                    <a href="about.php" class="text-gray-700 hover:text-primary-600 font-medium">About</a>
                    <a href="contact.php" class="text-gray-700 hover:text-primary-600 font-medium">Contact</a>
                </nav>

                <!-- User Actions -->
                <div class="flex items-center space-x-4">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="cart.php" class="relative p-2 text-gray-700 hover:text-primary-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5 6m0 0h9m-9 0V9a2 2 0 012-2h2m5 0V7a2 2 0 012-2h2m0 0V5a2 2 0 012-2h2"></path>
                            </svg>
                            <?php if ($cart_count > 0): ?>
                                <span class="absolute -top-1 -right-1 bg-primary-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center"><?php echo $cart_count; ?></span>
                            <?php endif; ?>
                        </a>
                        <a href="dashboard.php" class="text-gray-700 hover:text-primary-600 font-medium">Dashboard</a>
                        <a href="logout.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300 font-medium">Logout</a>
                    <?php else: ?>
                        <a href="login.php" class="text-gray-700 hover:text-primary-600 font-medium">Login</a>
                        <a href="register.php" class="bg-primary-500 text-white px-4 py-2 rounded-lg hover:bg-primary-600 font-medium">Sign Up</a>
                    <?php endif; ?>
                </div>

                <!-- Mobile Menu Button -->
                <button class="md:hidden p-2 text-gray-700" onclick="toggleMobileMenu()">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden md:hidden bg-white border-t border-gray-200">
            <div class="px-4 py-2 space-y-2">
                <a href="products.php" class="block py-2 text-gray-700 hover:text-primary-600">Products</a>
                <a href="categories.php" class="block py-2 text-gray-700 hover:text-primary-600">Categories</a>
                <a href="about.php" class="block py-2 text-gray-700 hover:text-primary-600">About</a>
                <a href="contact.php" class="block py-2 text-gray-700 hover:text-primary-600">Contact</a>
            </div>
        </div>
    </header>
