<?php
$page_title = "Home";
$page_description = "Shop premium smartphones, household appliances, and electronics at SavingVest Mart. Quality products, competitive prices, fast shipping.";

require_once 'config/database.php';
include 'includes/header.php';

// Get featured products
$conn = getDBConnection();
$featured_products = [];
$result = $conn->query("SELECT * FROM products WHERE is_featured = 1 AND is_active = 1 ORDER BY created_at DESC LIMIT 6");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $featured_products[] = $row;
    }
}

// Get categories
$categories = [];
$result = $conn->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY name ASC LIMIT 4");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
}
$conn->close();
?>

<!-- Hero Section -->
<section class="bg-gradient-to-br from-cyan-50 to-orange-50 py-20 relative overflow-hidden">
    <!-- Background geometric elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-cyan-100 rounded-full opacity-20"></div>
        <div class="absolute -bottom-20 -left-20 w-60 h-60 bg-orange-100 rounded-full opacity-20"></div>
        <div class="absolute top-1/2 left-1/4 w-4 h-4 bg-cyan-400 rounded-full opacity-30"></div>
        <div class="absolute top-1/3 right-1/3 w-2 h-2 bg-orange-400 rounded-full opacity-40"></div>
    </div>
    
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left side - Enhanced content -->
            <div class="space-y-8">
                <div class="space-y-6">
                    <h1 class="text-5xl md:text-7xl font-bold text-gray-900 leading-tight">
                        Elevate Your 
                        <span class="text-cyan-600">Tech Game</span>
                    </h1>
                    <p class="text-xl text-gray-600 leading-relaxed max-w-lg">
                        Explore the latest in electronics at unbeatable prices. Quality guaranteed, prices that save you money.
                    </p>
                </div>
                
                <!-- Trust indicators -->
                <div class="flex items-center space-x-6 text-sm text-gray-600">
                    <div class="flex items-center space-x-2">
                        <div class="w-5 h-5 bg-green-100 rounded-full flex items-center justify-center">
                            <svg class="w-3 h-3 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <span>Trusted by thousands</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-5 h-5 bg-blue-100 rounded-full flex items-center justify-center">
                            <svg class="w-3 h-3 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <span>Secure shopping guaranteed</span>
                    </div>
                </div>
                
                <!-- Action buttons -->
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="products.php" class="group bg-cyan-600 text-white px-8 py-4 rounded-lg font-semibold hover:bg-cyan-700 transition-all duration-300 text-center transform hover:scale-105 hover:shadow-lg">
                        <span class="group-hover:animate-pulse">Shop Now</span>
                    </a>
                    <a href="categories.php" class="border-2 border-cyan-600 text-cyan-600 px-8 py-4 rounded-lg font-semibold hover:bg-cyan-50 transition-all duration-300 text-center hover:shadow-md">
                        Browse Categories
                    </a>
                </div>
                
                <!-- Stats -->
                <div class="grid grid-cols-3 gap-6 pt-8 border-t border-gray-200">
                    <div class="text-center">
                        <div class="text-2xl font-bold text-gray-900">5000+</div>
                        <div class="text-sm text-gray-600">Happy Customers</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-gray-900">500+</div>
                        <div class="text-sm text-gray-600">Products</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-gray-900">24/7</div>
                        <div class="text-sm text-gray-600">Support</div>
                    </div>
                </div>
            </div>
            
            <!-- Right side - Dynamic product showcase -->
            <div class="relative">
                <!-- Main featured product -->
                <div class="relative bg-white rounded-3xl shadow-2xl p-8 transform hover:scale-105 transition-all duration-500">
                    <?php if (!empty($featured_products)): ?>
                        <?php $main_product = $featured_products[0]; ?>
                        <div class="absolute -top-4 -right-4 bg-orange-500 text-white px-4 py-2 rounded-full text-sm font-semibold animate-bounce">
                            Featured
                        </div>
                        <img src="<?php echo htmlspecialchars($main_product['image_url']); ?>" 
                             alt="<?php echo htmlspecialchars($main_product['name']); ?>"
                             class="w-full h-64 object-cover rounded-2xl mb-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-2">
                            <?php echo htmlspecialchars($main_product['name']); ?>
                        </h3>
                        <div class="flex items-center mb-3">
                            <div class="flex items-center">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <svg class="w-4 h-4 <?php echo $i <= floor($main_product['average_rating'] ?? 0) ? 'text-yellow-400' : 'text-gray-300'; ?>" 
                                         fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                <?php endfor; ?>
                                <span class="ml-2 text-sm text-gray-600">(<?php echo $main_product['review_count'] ?? 0; ?>)</span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div>
                                <?php if (!empty($main_product['sale_price'])): ?>
                                    <span class="text-2xl font-bold text-cyan-600">₦<?php echo number_format($main_product['sale_price'], 0); ?></span>
                                    <span class="text-lg text-gray-500 line-through ml-2">₦<?php echo number_format($main_product['price'], 0); ?></span>
                                <?php else: ?>
                                    <span class="text-2xl font-bold text-gray-900">₦<?php echo number_format($main_product['price'], 0); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Floating product cards -->
                <?php if (count($featured_products) > 1): ?>
                    <!-- Top right floating card -->
                    <div class="absolute -top-8 -right-8 bg-white rounded-2xl shadow-lg p-4 w-48 transform hover:scale-110 transition-all duration-300 hover:shadow-xl">
                        <?php $product2 = $featured_products[1]; ?>
                        <img src="<?php echo htmlspecialchars($product2['image_url']); ?>" 
                             alt="<?php echo htmlspecialchars($product2['name']); ?>"
                             class="w-full h-24 object-cover rounded-lg mb-2">
                        <h4 class="text-sm font-semibold text-gray-900 line-clamp-1">
                            <?php echo htmlspecialchars($product2['name']); ?>
                        </h4>
                        <div class="text-cyan-600 font-bold text-sm">
                            ₦<?php echo number_format($product2['sale_price'] ?? $product2['price'], 0); ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <?php if (count($featured_products) > 2): ?>
                    <!-- Bottom left floating card -->
                    <div class="absolute -bottom-6 -left-6 bg-white rounded-2xl shadow-lg p-4 w-48 transform hover:scale-110 transition-all duration-300 hover:shadow-xl">
                        <?php $product3 = $featured_products[2]; ?>
                        <img src="<?php echo htmlspecialchars($product3['image_url']); ?>" 
                             alt="<?php echo htmlspecialchars($product3['name']); ?>"
                             class="w-full h-24 object-cover rounded-lg mb-2">
                        <h4 class="text-sm font-semibold text-gray-900 line-clamp-1">
                            <?php echo htmlspecialchars($product3['name']); ?>
                        </h4>
                        <div class="text-cyan-600 font-bold text-sm">
                            ₦<?php echo number_format($product3['sale_price'] ?? $product3['price'], 0); ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Trust badges -->
                <div class="absolute top-4 left-4 space-y-2">
                    <div class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-xs font-medium flex items-center space-x-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Free Shipping</span>
                    </div>
                    <div class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-xs font-medium flex items-center space-x-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <span>30-Day Returns</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Categories -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Shop by Category</h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Explore our carefully curated categories of premium products
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php foreach ($categories as $category): ?>
            <a href="products.php?category=<?php echo urlencode($category['slug']); ?>" 
               class="group bg-white rounded-2xl shadow-sm hover:shadow-lg transition-all duration-300 overflow-hidden">
                <!-- Added actual category images instead of generic SVG icons -->
                <div class="aspect-w-16 aspect-h-12 bg-gray-100">
                    <img src="<?php echo htmlspecialchars($category['image_url']); ?>" 
                         alt="<?php echo htmlspecialchars($category['name']); ?>"
                         class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-2 group-hover:text-primary-600 transition-colors">
                        <?php echo htmlspecialchars($category['name']); ?>
                    </h3>
                    <p class="text-gray-600"><?php echo htmlspecialchars($category['description']); ?></p>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Featured Products</h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Handpicked premium products with exceptional quality and value
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php foreach ($featured_products as $product): ?>
            <div class="bg-white rounded-2xl shadow-sm hover:shadow-lg transition-shadow overflow-hidden">
                <div class="aspect-w-16 aspect-h-12 bg-gray-100">
                    <img src="<?php echo htmlspecialchars($product['image_url']); ?>" 
                         alt="<?php echo htmlspecialchars($product['name']); ?>"
                         class="w-full h-48 object-cover">
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">
                        <?php echo htmlspecialchars($product['name']); ?>
                    </h3>
                    <p class="text-gray-600 mb-4 line-clamp-2">
                        <?php echo htmlspecialchars($product['short_description']); ?>
                    </p>
                    
                    <div class="flex items-center mb-4">
                        <div class="flex items-center">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <svg class="w-4 h-4 <?php echo $i <= floor($product['average_rating'] ?? 0) ? 'text-yellow-400' : 'text-gray-300'; ?>" 
                                     fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            <?php endfor; ?>
                            <span class="ml-2 text-sm text-gray-600">(<?php echo $product['review_count'] ?? 0; ?>)</span>
                        </div>
                    </div>
                    
                    <div class="space-y-4">
                        <div class="flex items-center space-x-2">
                            <?php if (!empty($product['sale_price'])): ?>
                                <span class="text-2xl font-bold text-primary-600">₦<?php echo number_format($product['sale_price'], 0); ?></span>
                                <span class="text-lg text-gray-500 line-through">₦<?php echo number_format($product['price'], 0); ?></span>
                            <?php else: ?>
                                <span class="text-2xl font-bold text-gray-900">₦<?php echo number_format($product['price'], 0); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="products.php" class="bg-accent-500 text-white px-8 py-4 rounded-lg font-semibold hover:bg-accent-600 transition-colors">
                View All Products
            </a>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Free Shipping</h3>
                <p class="text-gray-600">Free shipping on orders over ₦79,200. Fast and reliable delivery nationwide.</p>
            </div>
            
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Quality Guarantee</h3>
                <p class="text-gray-600">All products come with manufacturer warranty and our quality guarantee.</p>
            </div>
            
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M12 2.944a11.955 11.955 0 00-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">24/7 Support</h3>
                <p class="text-gray-600">Expert customer support available around the clock to help you.</p>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
</merged_code>
