<?php
// Get parameters from URL
$width = isset($_GET['width']) ? (int)$_GET['width'] : 400;
$height = isset($_GET['height']) ? (int)$_GET['height'] : 400;
$text = isset($_GET['text']) ? urldecode($_GET['text']) : 'Product Image';

// Sanitize inputs
$width = max(50, min(1200, $width));
$height = max(50, min(1200, $height));
$text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');

// Set content type
header('Content-Type: image/svg+xml');
header('Cache-Control: public, max-age=3600');

// Generate SVG
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<svg width="<?php echo $width; ?>" height="<?php echo $height; ?>" xmlns="http://www.w3.org/2000/svg">
  <rect width="100%" height="100%" fill="#f3f4f6" stroke="#e5e7eb" stroke-width="1"/>
  <text x="50%" y="50%" font-family="Arial, sans-serif" font-size="<?php echo min(16, $width/20); ?>" fill="#6b7280" text-anchor="middle" dominant-baseline="middle">
    <?php echo $text; ?>
  </text>
</svg>
