<?php
$page_title = "Returns & Refunds";
$page_description = "Learn about SavingVest Mart's return policy, refund process, and how to return electronics and appliances for exchange or refund.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Returns & Refunds</h1>
        <p class="text-gray-600 mt-2">Our hassle-free return and refund policy</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="space-y-12">
            <!-- Return Policy -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">30-Day Return Policy</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-4">
                        We want you to be completely satisfied with your purchase. If you're not happy with your order, 
                        you can return most items within 30 days of delivery for a full refund or exchange.
                    </p>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Return Requirements</h3>
                    <ul class="space-y-2 text-gray-600">
                        <li>• Items must be in original, unused condition</li>
                        <li>• All original packaging and accessories included</li>
                        <li>• Return initiated within 30 days of delivery</li>
                        <li>• Valid proof of purchase required</li>
                    </ul>
                </div>
            </div>

            <!-- How to Return -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">How to Return an Item</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="bg-white rounded-lg shadow-sm p-6 text-center">
                        <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-primary-600 font-bold text-lg">1</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Contact Us</h3>
                        <p class="text-gray-600 text-sm">
                            Contact our customer service team to initiate a return request
                        </p>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6 text-center">
                        <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-primary-600 font-bold text-lg">2</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Get Return Label</h3>
                        <p class="text-gray-600 text-sm">
                            We'll provide a prepaid return shipping label for eligible returns
                        </p>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6 text-center">
                        <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-primary-600 font-bold text-lg">3</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Ship & Get Refund</h3>
                        <p class="text-gray-600 text-sm">
                            Ship the item back and receive your refund within 5-7 business days
                        </p>
                    </div>
                </div>
            </div>

            <!-- Refund Process -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Refund Process</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <div class="space-y-4">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Processing Time</h3>
                            <p class="text-gray-600">
                                Once we receive your returned item, we'll inspect it and process your refund within 3-5 business days. 
                                You'll receive an email confirmation when the refund is processed.
                            </p>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Refund Method</h3>
                            <p class="text-gray-600">
                                Refunds are processed using the original payment method. Bank transfers may take 3-7 business days 
                                to reflect in your account, while card refunds typically appear within 5-10 business days.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Non-Returnable Items -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Non-Returnable Items</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-4">The following items cannot be returned for hygiene and safety reasons:</p>
                    <ul class="space-y-2 text-gray-600">
                        <li>• Personal care appliances (electric toothbrushes, hair clippers, etc.)</li>
                        <li>• Software and digital downloads</li>
                        <li>• Customized or personalized items</li>
                        <li>• Items damaged by misuse or normal wear</li>
                        <li>• Items returned after 30 days</li>
                    </ul>
                </div>
            </div>

            <!-- Contact for Returns -->
            <div class="bg-primary-50 rounded-lg p-6 text-center">
                <h2 class="text-2xl font-bold text-gray-900 mb-4">Need to Return Something?</h2>
                <p class="text-gray-600 mb-6">Our customer service team is here to help make your return process smooth and easy.</p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="contact.php" class="bg-primary-500 text-white px-6 py-3 rounded-lg hover:bg-primary-600 font-medium">
                        Contact Support
                    </a>
                    <a href="tel:+2348012345678" class="border border-primary-500 text-primary-600 px-6 py-3 rounded-lg hover:bg-primary-50 font-medium">
                        Call: +234 801 234 5678
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
