-- Insert sample categories
INSERT INTO categories (name, slug, description, image_url) VALUES
('Smartphones', 'smartphones', 'Latest smartphones and mobile devices', '/images/categories/smartphones.jpg'),
('Household Appliances', 'household-appliances', 'Essential home appliances for modern living', '/images/categories/home-appliances.jpg'),
('Kitchen Appliances', 'kitchen-appliances', 'Professional kitchen equipment and appliances', '/images/categories/home-appliances.jpg'),
('Electronics', 'electronics', 'Consumer electronics and gadgets', '/images/categories/electronics.jpg');

-- Insert sample products (prices converted to Naira - 1 USD = 800 NGN approximately)
INSERT INTO products (name, slug, description, short_description, sku, price, sale_price, category_id, brand, stock_quantity, image_url, gallery_images, rating, review_count, is_featured) VALUES
('iPhone 15 Pro Max', 'iphone-15-pro-max', 'The most advanced iPhone ever with titanium design, A17 Pro chip, and professional camera system.', 'Latest iPhone with titanium design and A17 Pro chip', 'IPH15PM-256', 959200.00, 879200.00, 1, 'Apple', 50, '/images/products/iphone-15-pro-max.jpg', '[]', 4.8, 245, TRUE),
('Samsung Galaxy S24 Ultra', 'samsung-galaxy-s24-ultra', 'Premium Android smartphone with S Pen, advanced AI features, and exceptional camera capabilities.', 'Premium Android with S Pen and AI features', 'SGS24U-512', 1039200.00, NULL, 1, 'Samsung', 35, '/images/products/samsung-galaxy-s24-ultra.jpg', '[]', 4.7, 189, TRUE),
('Dyson V15 Detect', 'dyson-v15-detect', 'Powerful cordless vacuum with laser dust detection and advanced filtration system.', 'Cordless vacuum with laser dust detection', 'DYS-V15-DET', 599200.00, 559200.00, 2, 'Dyson', 25, '/images/products/dyson-v15-detect.jpg', '[]', 4.6, 156, TRUE),
('KitchenAid Stand Mixer', 'kitchenaid-stand-mixer', 'Professional 5-quart stand mixer perfect for baking and cooking enthusiasts.', '5-quart professional stand mixer', 'KAD-SM-5QT', 319200.00, NULL, 3, 'KitchenAid', 40, '/images/products/kitchenaid-mixer.jpg', '[]', 4.9, 312, TRUE),
('Google Pixel 8 Pro', 'google-pixel-8-pro', 'AI-powered smartphone with exceptional camera and pure Android experience.', 'AI-powered smartphone with pure Android', 'GPX8P-128', 799200.00, 719200.00, 1, 'Google', 30, '/images/products/google-pixel-8-pro.jpg', '[]', 4.5, 98, FALSE),
('Ninja Air Fryer Pro', 'ninja-air-fryer-pro', 'Large capacity air fryer with multiple cooking functions and digital controls.', 'Large capacity air fryer with digital controls', 'NJA-AFP-8QT', 159200.00, 127200.00, 3, 'Ninja', 45, '/images/products/ninja-air-fryer.jpg', '[]', 4.6, 234, FALSE),
('iPad Pro 12.9"', 'ipad-pro-12-inch', 'Professional tablet with M2 chip, Liquid Retina XDR display, and Apple Pencil support.', 'Professional tablet with M2 chip', 'IPD-PRO-12-256', 879200.00, NULL, 4, 'Apple', 20, '/images/products/ipad-pro-12-inch.jpg', '[]', 4.7, 167, TRUE),
('iRobot Roomba j7+', 'irobot-roomba-j7', 'Smart robot vacuum with obstacle avoidance and automatic dirt disposal.', 'Smart robot vacuum with auto-disposal', 'IRB-J7-PLUS', 639200.00, 559200.00, 2, 'iRobot', 15, '/images/products/irobot-roomba-j7.jpg', '[]', 4.4, 189, FALSE),
('LG OLED C3 55"', 'lg-oled-c3-55', '55-inch OLED smart TV with 4K resolution and webOS platform.', '55-inch OLED 4K smart TV', 'LG-C3-55-OLED', 1199200.00, 1079200.00, 4, 'LG', 12, '/images/products/lg-oled-c3-55.jpg', '[]', 4.8, 145, TRUE),
('MacBook Pro 14"', 'macbook-pro-14', 'Professional laptop with M3 Pro chip, Liquid Retina XDR display, and all-day battery.', 'Professional laptop with M3 Pro chip', 'MBP-14-M3-512', 1599200.00, NULL, 4, 'Apple', 18, '/images/products/macbook-pro-14.png', '[]', 4.9, 203, TRUE),
('Sony WH-1000XM5', 'sony-wh1000xm5', 'Premium noise-canceling wireless headphones with exceptional sound quality.', 'Premium noise-canceling wireless headphones', 'SNY-WH1000XM5', 319200.00, 279200.00, 4, 'Sony', 35, '/images/products/sony-wh1000xm5.png', '[]', 4.7, 298, FALSE),
('Instant Pot Duo 7-in-1', 'instant-pot-duo-7in1', 'Multi-functional pressure cooker that replaces 7 kitchen appliances in one.', '7-in-1 multi-functional pressure cooker', 'IPD-7IN1-6QT', 79200.00, 63200.00, 3, 'Instant Pot', 60, '/images/products/instant-pot-duo.png', '[]', 4.7, 423, FALSE);

-- Insert sample user (password is 'password123' - you need to generate proper hash)
INSERT INTO users (username, email, password_hash, first_name, last_name, phone, address, city, state, zip_code) VALUES
('admin', 'admin@mart.savingvest.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 'User', '08012345678', '123 Victoria Island', 'Lagos', 'Lagos State', '101241'),
('john_doe', 'john@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'John', 'Doe', '08087654321', '456 Garki District', 'Abuja', 'FCT', '900001');
