-- Create admin user
-- Add role column to users table (ignore error if column already exists)
ALTER TABLE users ADD COLUMN role ENUM('user', 'admin') DEFAULT 'user';

-- Insert admin user (password: admin123)
-- First, let's generate the correct password hash
INSERT INTO users (full_name, email, password, phone, role, created_at) 
VALUES (
    'System Administrator',
    'admin@savingvest.com',
    '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm',
    '+2348038928708',
    'admin',
    NOW()
) ON DUPLICATE KEY UPDATE 
    password = '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm',
    role = 'admin',
    phone = '+2348038928708';

-- Alternative script if the above fails due to existing column
-- You can run this separately if needed:
-- UPDATE users SET role = 'admin' WHERE email = 'admin@savingvest.com';
