<?php
$page_title = "Shipping Information";
$page_description = "Learn about SavingVest Mart's shipping options, delivery times, and shipping costs for electronics and appliances across Nigeria.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Shipping Information</h1>
        <p class="text-gray-600 mt-2">Everything you need to know about our shipping options</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="space-y-12">
            <!-- Shipping Options -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Shipping Options</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Standard Shipping</h3>
                        <ul class="space-y-2 text-gray-600">
                            <li>• Lagos: 2-3 business days</li>
                            <li>• Other states: 3-7 business days</li>
                            <li>• Cost: ₦2,500 - ₦5,000</li>
                            <li>• Free on orders over ₦79,200</li>
                        </ul>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Express Shipping</h3>
                        <ul class="space-y-2 text-gray-600">
                            <li>• Lagos: 1-2 business days</li>
                            <li>• Other states: 2-4 business days</li>
                            <li>• Cost: ₦5,000 - ₦10,000</li>
                            <li>• Available for most products</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Delivery Areas -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Delivery Areas</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-4">We currently deliver to all 36 states in Nigeria including the FCT. Delivery times may vary based on location and product availability.</p>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm text-gray-600">
                        <div>
                            <h4 class="font-semibold text-gray-900 mb-2">Major Cities (1-3 days)</h4>
                            <ul class="space-y-1">
                                <li>Lagos</li>
                                <li>Abuja</li>
                                <li>Port Harcourt</li>
                                <li>Kano</li>
                            </ul>
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900 mb-2">Regional Centers (2-5 days)</h4>
                            <ul class="space-y-1">
                                <li>Ibadan</li>
                                <li>Benin City</li>
                                <li>Enugu</li>
                                <li>Kaduna</li>
                            </ul>
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900 mb-2">Other States (3-7 days)</h4>
                            <ul class="space-y-1">
                                <li>All other state capitals</li>
                                <li>Major towns</li>
                                <li>Remote areas</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Special Items -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Special Shipping Requirements</h2>
                <div class="space-y-4">
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Large Appliances</h3>
                        <p class="text-gray-600">
                            Large appliances like refrigerators, washing machines, and air conditioners require special handling. 
                            Delivery may take 5-10 business days and includes white glove delivery service with installation options.
                        </p>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Fragile Electronics</h3>
                        <p class="text-gray-600">
                            TVs, monitors, and other fragile electronics are packaged with extra care and may require signature upon delivery. 
                            We recommend being available during the delivery window.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Tracking -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Order Tracking</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-4">
                        Once your order is shipped, you'll receive a tracking number via email and SMS. You can track your package using:
                    </p>
                    <ul class="space-y-2 text-gray-600">
                        <li>• Your account dashboard</li>
                        <li>• Email tracking link</li>
                        <li>• SMS updates</li>
                        <li>• Customer service hotline</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
