<?php
// Script to update all image paths in the database to use the new placeholder system
require_once 'config/database.php';

// Update products table
$update_products = "UPDATE products SET 
    image_url = CONCAT('/placeholder.php?width=400&height=400&text=', REPLACE(name, ' ', '+')),
    gallery_images = CONCAT('[\"', '/placeholder.php?width=400&height=400&text=', REPLACE(name, ' ', '+'), '\"]')";

if (mysqli_query($conn, $update_products)) {
    echo "✅ Products images updated successfully\n";
} else {
    echo "❌ Error updating products: " . mysqli_error($conn) . "\n";
}

// Update categories table
$update_categories = "UPDATE categories SET 
    image_url = CONCAT('/placeholder.php?width=300&height=200&text=', REPLACE(name, ' ', '+'))";

if (mysqli_query($conn, $update_categories)) {
    echo "✅ Categories images updated successfully\n";
} else {
    echo "❌ Error updating categories: " . mysqli_error($conn) . "\n";
}

echo "\n🎉 All image paths have been updated to use the dynamic placeholder system!\n";
echo "Now your images will display properly with product names as placeholders.\n";

mysqli_close($conn);
?>
