<?php
$page_title = "About Us";
$page_description = "Learn about SavingVest Mart - your trusted destination for premium electronics and household appliances with quality products and exceptional service.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">About SavingVest Mart</h1>
        <p class="text-gray-600 mt-2">Your trusted partner in premium electronics and home appliances</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="text-3xl font-bold text-gray-900 mb-6">Our Story</h2>
                <!-- Updated company background and structure -->
                <p class="text-gray-600 mb-4">
                    SavingVest Mart is part of SavingVest, a financial co-operative that provides savings, loans, and a comprehensive range of services to its members. As a subsidiary of Mpaying Hitech Limited, registered under the Corporate Affairs Commission in 2018, we were created with a specific mission.
                </p>
                <p class="text-gray-600 mb-4">
                    Our mart was established to enable our members to acquire quality electronics and household appliances easier and at more affordable prices. We bridge the gap between financial empowerment and access to essential technology and home solutions.
                </p>
                <p class="text-gray-600 mb-4">
                    Through our parent company's financial services and our retail expertise, we offer unique advantages to our members, including flexible payment options, special member discounts, and integrated financial solutions.
                </p>
                <p class="text-gray-600">
                    Our commitment extends beyond retail - we're building a community where financial growth and access to quality products go hand in hand, making premium electronics and appliances accessible to everyone.
                </p>
            </div>
            <div class="bg-gray-100 rounded-2xl p-8">
                <img src="/placeholder.svg?height=400&width=500&text=SavingVest+Mart+Story" 
                     alt="About SavingVest Mart" 
                     class="w-full h-auto rounded-lg">
            </div>
        </div>
    </div>
</section>

<!-- Added company structure section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Our Corporate Structure</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Understanding our heritage and commitment to financial empowerment</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center p-6 bg-gray-50 rounded-lg">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Mpaying Hitech Limited</h3>
                <p class="text-gray-600">Parent company registered under Corporate Affairs Commission in 2018, providing the foundation for our operations.</p>
            </div>
            <div class="text-center p-6 bg-gray-50 rounded-lg">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">SavingVest Co-operative</h3>
                <p class="text-gray-600">Financial co-operative providing savings, loans, and comprehensive financial services to our growing member community.</p>
            </div>
            <div class="text-center p-6 bg-primary-50 rounded-lg border-2 border-primary-200">
                <div class="w-16 h-16 bg-primary-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">SavingVest Mart</h3>
                <p class="text-gray-600">Our retail arm, created to help members acquire quality electronics and appliances easier and more affordably.</p>
            </div>
        </div>
    </div>
</section>

<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Why Choose Us</h2>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Quality Guaranteed</h3>
                <p class="text-gray-600">All products come with manufacturer warranty and our quality guarantee.</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Member Benefits</h3>
                <p class="text-gray-600">Special pricing and flexible payment options for SavingVest co-operative members.</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M12 2.944a11.955 11.955 0 00-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">24/7 Support</h3>
                <p class="text-gray-600">Expert customer support available around the clock to help you.</p>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
