<?php
$page_title = "Frequently Asked Questions";
$page_description = "Find answers to common questions about shopping at SavingVest Mart, shipping, returns, warranties, and more.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Frequently Asked Questions</h1>
        <p class="text-gray-600 mt-2">Find answers to common questions</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="space-y-8">
            <!-- FAQ Item -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">How do I place an order?</h3>
                <p class="text-gray-600">
                    Simply browse our products, add items to your cart, and proceed to checkout. You'll need to create an account 
                    or log in to complete your purchase. Follow the step-by-step checkout process to enter your shipping and payment information.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">What payment methods do you accept?</h3>
                <p class="text-gray-600">
                    We accept various payment methods including Paystack, Flutterwave, bank transfers, and cash on delivery. 
                    All online payments are processed securely through our trusted payment partners.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">How long does shipping take?</h3>
                <p class="text-gray-600">
                    Standard shipping typically takes 2-5 business days within Lagos and 3-7 business days to other states in Nigeria. 
                    Express shipping options are available for faster delivery. Free shipping is available on orders over ₦79,200.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">What is your return policy?</h3>
                <p class="text-gray-600">
                    We offer a 30-day return policy for most items. Products must be in original condition with all packaging and accessories. 
                    Some items like software and personalized products may have different return policies. Contact our support team to initiate a return.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">Do products come with warranty?</h3>
                <p class="text-gray-600">
                    Yes, all products come with manufacturer warranty. Warranty periods vary by product and manufacturer. 
                    We also provide additional warranty options for extended coverage on select items.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">How can I track my order?</h3>
                <p class="text-gray-600">
                    Once your order ships, you'll receive a tracking number via email and SMS. You can also track your order 
                    by logging into your account and viewing your order history in the dashboard.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">Can I cancel or modify my order?</h3>
                <p class="text-gray-600">
                    Orders can be cancelled or modified within 2 hours of placement, provided they haven't been processed for shipping. 
                    Contact our customer service team immediately if you need to make changes to your order.
                </p>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">Do you offer installation services?</h3>
                <p class="text-gray-600">
                    Yes, we offer professional installation services for select appliances and electronics. Installation fees vary by product 
                    and location. Contact us for more information about installation services in your area.
                </p>
            </div>
        </div>

        <div class="mt-12 text-center">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Still have questions?</h2>
            <p class="text-gray-600 mb-6">Our customer support team is here to help</p>
            <a href="contact.php" class="bg-primary-500 text-white px-6 py-3 rounded-lg hover:bg-primary-600 font-medium">
                Contact Support
            </a>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
