<?php
$page_title = "Forgot Password";
$page_description = "Reset your SavingVest Mart account password.";

require_once 'config/database.php';

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit;
}

$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    
    if (empty($email)) {
        $error_message = 'Please enter your email address.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error_message = 'Please enter a valid email address.';
    } else {
        $conn = getDBConnection();
        
        $sql = "SELECT id, first_name FROM users WHERE email = ? AND is_active = 1";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
        
        if ($user) {
            // In a real implementation, you would:
            // 1. Generate a secure reset token
            // 2. Store it in the database with expiration
            // 3. Send an email with the reset link
            
            $success_message = 'If an account with that email exists, we\'ve sent password reset instructions to your email address.';
        } else {
            // Don't reveal if email exists or not for security
            $success_message = 'If an account with that email exists, we\'ve sent password reset instructions to your email address.';
        }
        
        $conn->close();
    }
}

include 'includes/header.php';
?>

<!-- Forgot Password Form -->
<section class="py-16 bg-gray-50 min-h-screen flex items-center">
    <div class="max-w-md mx-auto w-full px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-lg shadow-sm p-8">
            <!-- Logo and Title -->
            <div class="text-center mb-8">
                <div class="flex items-center justify-center space-x-2 mb-4">
                    <div class="w-10 h-10 bg-primary-500 rounded-lg flex items-center justify-center">
                        <span class="text-white font-bold text-xl">S</span>
                    </div>
                    <span class="text-2xl font-bold text-gray-900">SavingVest Mart</span>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Forgot Password</h1>
                <p class="text-gray-600">Enter your email to reset your password</p>
            </div>
            
            <!-- Error/Success Messages -->
            <?php if ($error_message): ?>
                <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($error_message); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($success_message): ?>
                <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($success_message); ?>
                </div>
            <?php endif; ?>
            
            <!-- Forgot Password Form -->
            <form method="POST" class="space-y-6">
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                    <input type="email" id="email" name="email" required
                           value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                           placeholder="Enter your email address">
                </div>
                
                <button type="submit" 
                        class="w-full bg-primary-500 text-white py-2 px-4 rounded-lg font-semibold hover:bg-primary-600 focus:ring-2 focus:ring-primary-500 focus:ring-offset-2">
                    Send Reset Instructions
                </button>
            </form>
            
            <!-- Back to Login -->
            <div class="mt-6 text-center">
                <a href="login.php" class="text-primary-600 hover:text-primary-800 font-medium">
                    ← Back to Login
                </a>
            </div>
        </div>
        
        <!-- Demo Note -->
        <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
            <h3 class="text-sm font-medium text-blue-800 mb-2">Demo Note</h3>
            <p class="text-sm text-blue-700">
                This is a demo implementation. In production, this would send an actual email with reset instructions.
            </p>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
