<?php
$page_title = "Privacy Policy";
$page_description = "Read SavingVest Mart's privacy policy to understand how we collect, use, and protect your personal information when shopping with us.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Privacy Policy</h1>
        <p class="text-gray-600 mt-2">Last updated: <?php echo date('F j, Y'); ?></p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="prose prose-lg max-w-none">
            <div class="space-y-8">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Information We Collect</h2>
                    <p class="text-gray-600 mb-4">
                        We collect information you provide directly to us, such as when you create an account, 
                        make a purchase, or contact us for support.
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Personal information (name, email, phone number, address)</li>
                        <li>Payment information (processed securely by our payment partners)</li>
                        <li>Order history and preferences</li>
                        <li>Communication preferences</li>
                        <li>Device and usage information</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">How We Use Your Information</h2>
                    <p class="text-gray-600 mb-4">We use the information we collect to:</p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Process and fulfill your orders</li>
                        <li>Provide customer service and support</li>
                        <li>Send you order confirmations and shipping updates</li>
                        <li>Improve our products and services</li>
                        <li>Send promotional communications (with your consent)</li>
                        <li>Prevent fraud and ensure security</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Information Sharing</h2>
                    <p class="text-gray-600 mb-4">
                        We do not sell, trade, or otherwise transfer your personal information to third parties 
                        except as described in this policy:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Service providers who assist in our operations</li>
                        <li>Payment processors for transaction processing</li>
                        <li>Shipping companies for order delivery</li>
                        <li>Legal requirements or to protect our rights</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Data Security</h2>
                    <p class="text-gray-600">
                        We implement appropriate security measures to protect your personal information against 
                        unauthorized access, alteration, disclosure, or destruction. This includes encryption 
                        of sensitive data and secure storage practices.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Your Rights</h2>
                    <p class="text-gray-600 mb-4">You have the right to:</p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Access your personal information</li>
                        <li>Correct inaccurate information</li>
                        <li>Delete your account and personal data</li>
                        <li>Opt-out of marketing communications</li>
                        <li>Request data portability</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Cookies and Tracking</h2>
                    <p class="text-gray-600">
                        We use cookies and similar technologies to enhance your browsing experience, 
                        analyze site traffic, and personalize content. You can control cookie settings 
                        through your browser preferences.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Contact Us</h2>
                    <p class="text-gray-600">
                        If you have questions about this Privacy Policy or our data practices, 
                        please contact us at:
                    </p>
                    <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                        <p class="text-gray-600">
                            Email: privacy@mart.savingvest.com<br>
                            Phone: +234 801 234 5678<br>
                            Address: 123 Victoria Island, Lagos, Nigeria
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
