-- Alternative approach: Check and add role column step by step
-- Run this if the main script fails

-- Step 1: Try to add the role column (will show error if exists, but that's okay)
ALTER TABLE users ADD COLUMN role ENUM('user', 'admin') DEFAULT 'user';

-- Step 2: Insert or update admin user
INSERT INTO users (full_name, email, password, phone, role, created_at) 
VALUES (
    'System Administrator',
    'admin@savingvest.com',
    '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm',
    '+2348038928708',
    'admin',
    NOW()
) ON DUPLICATE KEY UPDATE 
    password = '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm',
    role = 'admin',
    phone = '+2348038928708';

-- Step 3: Set all existing users to 'user' role if they don't have one
UPDATE users SET role = 'user' WHERE role IS NULL;
