<?php
$page_title = "Terms of Service";
$page_description = "Read SavingVest Mart's terms of service to understand the terms and conditions for using our website and purchasing our products.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Terms of Service</h1>
        <p class="text-gray-600 mt-2">Last updated: <?php echo date('F j, Y'); ?></p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="prose prose-lg max-w-none">
            <div class="space-y-8">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Acceptance of Terms</h2>
                    <p class="text-gray-600">
                        By accessing and using the SavingVest Mart website, you accept and agree to be bound by 
                        the terms and provision of this agreement. If you do not agree to abide by the above, 
                        please do not use this service.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Use License</h2>
                    <p class="text-gray-600 mb-4">
                        Permission is granted to temporarily download one copy of the materials on SavingVest Mart's 
                        website for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title, and under this license you may not:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Modify or copy the materials</li>
                        <li>Use the materials for any commercial purpose or for any public display</li>
                        <li>Attempt to reverse engineer any software contained on the website</li>
                        <li>Remove any copyright or other proprietary notations from the materials</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Product Information</h2>
                    <p class="text-gray-600">
                        We strive to provide accurate product information, including descriptions, prices, and availability. 
                        However, we do not warrant that product descriptions or other content is accurate, complete, 
                        reliable, current, or error-free. Prices and availability are subject to change without notice.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Orders and Payment</h2>
                    <p class="text-gray-600 mb-4">
                        By placing an order, you represent that you are authorized to use the payment method and 
                        that the information you provide is accurate. We reserve the right to:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-600">
                        <li>Refuse or cancel any order</li>
                        <li>Limit quantities on any order</li>
                        <li>Verify payment information</li>
                        <li>Correct pricing errors</li>
                    </ul>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Shipping and Delivery</h2>
                    <p class="text-gray-600">
                        We will make reasonable efforts to deliver products within the estimated timeframes. 
                        However, delivery dates are estimates and we are not liable for delays caused by 
                        circumstances beyond our control.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Returns and Refunds</h2>
                    <p class="text-gray-600">
                        Our return policy allows returns within 30 days of purchase for most items. 
                        Please refer to our Returns & Refunds page for complete details on eligibility, 
                        process, and restrictions.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Limitation of Liability</h2>
                    <p class="text-gray-600">
                        In no event shall SavingVest Mart or its suppliers be liable for any damages 
                        (including, without limitation, damages for loss of data or profit, or due to 
                        business interruption) arising out of the use or inability to use the materials 
                        on our website, even if we have been notified orally or in writing of the 
                        possibility of such damage.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Governing Law</h2>
                    <p class="text-gray-600">
                        These terms and conditions are governed by and construed in accordance with the 
                        laws of Nigeria and you irrevocably submit to the exclusive jurisdiction of the 
                        courts in that State or location.
                    </p>
                </div>

                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Contact Information</h2>
                    <p class="text-gray-600">
                        If you have any questions about these Terms of Service, please contact us:
                    </p>
                    <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                        <p class="text-gray-600">
                            Email: legal@mart.savingvest.com<br>
                            Phone: +234 801 234 5678<br>
                            Address: 123 Victoria Island, Lagos, Nigeria
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
